/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorWellTrainedModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> WELL = TConstruct.createKey((String)"well_trained_armor");

    public ArmorWellTrainedModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorWellTrainedModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(WELL, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(WELL, (Object)0);
            if (level > 0 && event.getAmount() > 0.0f) {
                event.setAmount(event.getAmount() * (1.0f - Math.min(0.6f, RANDOM.nextFloat(0.4f) * (float)level)));
            }
        });
    }
}

